<?php

	# script adapted from highcharts.com
	# modified for Meteotemplate
	
	# unit conversion based on Meteotemplate setting
	# time conversion to local time
	# Meteotemplate theme styling
	# localization based on Meteotemplate translation files

	include("../../../config.php");
	include("../../../header.php");
	include("../../../css/design.php");
	
	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}

	$meteogramLocations = explode(";",$meteogramLocations);
	foreach($meteogramLocations as $meteogramLocation){
		$meteogramIDs[] = explode(",",$meteogramLocation);
	}

	if(!is_dir("cache")){
		mkdir("cache");
	}
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];

	
	
?>
<!DOCTYPE html>
<html>
	<head>
		<title><?php echo lang("meteogram",'c')?></title>
		<?php metaHeader()?>
		
		<script type="text/javascript" src="<?php echo $pageURL.$path?>scripts/highcharts.js"></script>
		<script type="text/javascript" src="<?php echo $pageURL.$path?>scripts/highcharts-more.js"></script>
		<script type="text/javascript" src="<?php echo $pageURL.$path?>scripts/exporting.js"></script>
		
		<style>
			body,#main{
				background:none;
			}
		</style>
	</head>
	<body>
		<div id="main">
			<div style="position:relative;width:95%;margin: 0 auto;text-align:center">
				<?php 
					if(count($meteogramLocations)>1){
				?>
						<select class="button2" id="idLocation" style="margin-bottom:5px">
							<?php 
								foreach($meteogramIDs as $key=>$meteogramID){
							?>
									<option value=<?php echo $key?> <?php if($key==0){echo "selected";}?>><?php echo $meteogramID[0]?></option>
							<?php 
								}
							?>
						</select>
				<?php 
					}
					else{
				?>
						<input type="hidden" id="idLocation" value="0">
				<?php
					}
				?>
				<div id="container" style="width: 98%; height: 310px; margin: 0 auto">
					<div style="margin-top: 100px; text-align: center" id="loading">
						<i class="fa fa-spinner fa-spin"></i> Loading data from external source
					</div>
				</div>
			</div>
		</div>
		<script>
			Highcharts.setOptions({
				global: {
					useUTC: true
				},
				lang: {
					months: ['<?php echo lang('january','c')?>', '<?php echo lang('february','c')?>', '<?php echo lang('march','c')?>', '<?php echo lang('april','c')?>', '<?php echo lang('may','c')?>', '<?php echo lang('june','c')?>', '<?php echo lang('july','c')?>', '<?php echo lang('august','c')?>', '<?php echo lang('september','c')?>', '<?php echo lang('october','c')?>', '<?php echo lang('november','c')?>', '<?php echo lang('december','c')?>'],
					shortMonths: ['<?php echo lang('janAbbr','c')?>', '<?php echo lang('febAbbr','c')?>', '<?php echo lang('marAbbr','c')?>', '<?php echo lang('aprAbbr','c')?>', '<?php echo lang('mayAbbr','c')?>', '<?php echo lang('junAbbr','c')?>', '<?php echo lang('julAbbr','c')?>', '<?php echo lang('augAbbr','c')?>', '<?php echo lang('sepAbbr','c')?>', '<?php echo lang('octAbbr','c')?>', '<?php echo lang('novAbbr','c')?>', '<?php echo lang('decAbbr','c')?>'],
					weekdays: ['<?php echo lang('sundayAbbr','c')?>', '<?php echo lang('mondayAbbr','c')?>', '<?php echo lang('tuesdayAbbr','c')?>', '<?php echo lang('wednesdayAbbr','c')?>', '<?php echo lang('thursdayAbbr','c')?>', '<?php echo lang('fridayAbbr','c')?>', '<?php echo lang('saturdayAbbr','c')?>'],
					resetZoom: ['<?php echo lang('default zoom','c')?>']
				}		
			});
		</script>
		<?php include("../../../css/highcharts.php");?>
		<script>

			function Meteogram(xml, container) {
				// Parallel arrays for the chart data, these are populated as the XML/JSON file
				// is loaded
				this.symbols = [];
				this.symbolNames = [];
				this.precipitations = [];
				this.windDirections = [];
				this.windDirectionNames = [];
				this.windSpeeds = [];
				this.windSpeedNames = [];
				this.temperatures = [];
				this.pressures = [];

				// Initialize
				this.xml = xml;
				this.container = container;

				// Run
				this.parseYrData();
			}

			Meteogram.prototype.getSymbolSprites = function (symbolSize) {
				return {
					'01d': {
						x: 0,
						y: 0
					},
					'01n': {
						x: symbolSize,
						y: 0
					},
					'16': {
						x: 2 * symbolSize,
						y: 0
					},
					'02d': {
						x: 0,
						y: symbolSize
					},
					'02n': {
						x: symbolSize,
						y: symbolSize
					},
					'03d': {
						x: 0,
						y: 2 * symbolSize
					},
					'03n': {
						x: symbolSize,
						y: 2 * symbolSize
					},
					'17': {
						x: 2 * symbolSize,
						y: 2 * symbolSize
					},
					'04': {
						x: 0,
						y: 3 * symbolSize
					},
					'05d': {
						x: 0,
						y: 4 * symbolSize
					},
					'05n': {
						x: symbolSize,
						y: 4 * symbolSize
					},
					'18': {
						x: 2 * symbolSize,
						y: 4 * symbolSize
					},
					'06d': {
						x: 0,
						y: 5 * symbolSize
					},
					'06n': {
						x: symbolSize,
						y: 5 * symbolSize
					},
					'07d': {
						x: 0,
						y: 6 * symbolSize
					},
					'07n': {
						x: symbolSize,
						y: 6 * symbolSize
					},
					'08d': {
						x: 0,
						y: 7 * symbolSize
					},
					'08n': {
						x: symbolSize,
						y: 7 * symbolSize
					},
					'19': {
						x: 2 * symbolSize,
						y: 7 * symbolSize
					},
					'09': {
						x: 0,
						y: 8 * symbolSize
					},
					'10': {
						x: 0,
						y: 9 * symbolSize
					},
					'11': {
						x: 0,
						y: 10 * symbolSize
					},
					'12': {
						x: 0,
						y: 11 * symbolSize
					},
					'13': {
						x: 0,
						y: 12 * symbolSize
					},
					'14': {
						x: 0,
						y: 13 * symbolSize
					},
					'15': {
						x: 0,
						y: 14 * symbolSize
					},
					'20d': {
						x: 0,
						y: 15 * symbolSize
					},
					'20n': {
						x: symbolSize,
						y: 15 * symbolSize
					},
					'20m': {
						x: 2 * symbolSize,
						y: 15 * symbolSize
					},
					'21d': {
						x: 0,
						y: 16 * symbolSize
					},
					'21n': {
						x: symbolSize,
						y: 16 * symbolSize
					},
					'21m': {
						x: 2 * symbolSize,
						y: 16 * symbolSize
					},
					'22': {
						x: 0,
						y: 17 * symbolSize
					},
					'23': {
						x: 0,
						y: 18 * symbolSize
					}
				};
			};
			Meteogram.prototype.smoothLine = function (data) {
				var i = data.length,
					sum,
					value;

				while (i--) {
					data[i].value = value = data[i].y;
					sum = (data[i - 1] || data[i]).y + value + (data[i + 1] || data[i]).y;
					data[i].y = Math.max(value - 0.5, Math.min(sum / 3, value + 0.5));
				}
			};
			Meteogram.prototype.tooltipFormatter = function (tooltip) {
				var index = tooltip.points[0].point.index,
					ret = '<small>' + Highcharts.dateFormat('%A, %b %e, %H:%M', tooltip.x) + '-' +
						Highcharts.dateFormat('%H:%M', tooltip.points[0].point.to) + '</small><br>';
				ret += '<b>' + this.symbolNames[index] + '</b>';

				ret += '<table>';
				Highcharts.each(tooltip.points, function (point) {
					var series = point.series;
					ret += '<tr><td style="text-align:left"><span style="color:' + series.color + '">\u25CF</span> ' + series.name +
						': </td><td style="white-space:nowrap;style="text-align:left">' + Highcharts.pick(point.point.value, point.y) +
						series.options.tooltip.valueSuffix + '</td></tr>';
				});
				ret += '<tr><td style="vertical-align: top;text-align:left">\u25CF <?php echo lang('wind','c')?></td><td style="white-space:nowrap;text-align:left">' + this.windDirectionNames[index] +
					'<br>' + this.windSpeedNames[index] + ' (' +
					Highcharts.numberFormat(this.windSpeeds[index], 1) + ' <?php echo $displayWindUnits?>)</td></tr>';
				ret += '</table>';
				return ret;
			};
			Meteogram.prototype.drawWeatherSymbols = function (chart) {
				var meteogram = this,
					symbolSprites = this.getSymbolSprites(30);

				$.each(chart.series[0].data, function (i, point) {
					var sprite,
						group;

					if (meteogram.resolution > 36e5 || i % 2 === 0) {

						sprite = symbolSprites[meteogram.symbols[i]];
						if (sprite) {
							group = chart.renderer.g()
								.attr({
									translateX: point.plotX + chart.plotLeft - 15,
									translateY: point.plotY + chart.plotTop - 30,
									zIndex: 5
								})
								.clip(chart.renderer.clipRect(0, 0, 30, 30))
								.add();
							chart.renderer.image(
								'symbols.png',
								-sprite.x,
								-sprite.y,
								90,
								570
							)
								.add(group);
						}
					}
				});
			};
			Meteogram.prototype.windArrow = function (name) {
				var level,
					path;
				path = [
					'M', 0, 7, // base of arrow
					'L', -1.5, 7,
					0, 10,
					1.5, 7,
					0, 7,
					0, -10 // top
				];
				level = $.inArray(name, ['Calm', 'Light air', 'Light breeze', 'Gentle breeze', 'Moderate breeze','Fresh breeze', 'Strong breeze', 'Near gale', 'Gale', 'Strong gale', 'Storm', 'Violent storm', 'Hurricane']);

				if (level === 0) {
					path = [];
				}

				if (level === 2) {
					path.push('M', 0, -8, 'L', 4, -8); // short line
				} else if (level >= 3) {
					path.push(0, -10, 7, -10); // long line
				}

				if (level === 4) {
					path.push('M', 0, -7, 'L', 4, -7);
				} else if (level >= 5) {
					path.push('M', 0, -7, 'L', 7, -7);
				}

				if (level === 5) {
					path.push('M', 0, -4, 'L', 4, -4);
				} else if (level >= 6) {
					path.push('M', 0, -4, 'L', 7, -4);
				}

				if (level === 7) {
					path.push('M', 0, -1, 'L', 4, -1);
				} else if (level >= 8) {
					path.push('M', 0, -1, 'L', 7, -1);
				}

				return path;
			};
			Meteogram.prototype.drawWindArrows = function (chart) {
				var meteogram = this;

				$.each(chart.series[0].data, function (i, point) {
					var arrow, x, y;

					if (meteogram.resolution > 36e5 || i % 2 === 0) {
						x = point.plotX + chart.plotLeft + 7;
						y = 255;
						if (meteogram.windSpeedNames[i] === '<?php echo lang('beaufort0','c')?>') {
							arrow = chart.renderer.circle(x, y, 10).attr({
								fill: 'none'
							});
						} else {
							arrow = chart.renderer.path(
								meteogram.windArrow(meteogram.windSpeedNames[i])
							).attr({
								rotation: parseInt(meteogram.windDirections[i], 10),
								translateX: x, // rotation center
								translateY: y // rotation center
							});
						}
						arrow.attr({
							stroke: '<?php echo $theme=="dark" ? "white" : "black"?>',
							'stroke-width': 1.5,
							zIndex: 5,
						})
						.add();

					}
				});
			};
			Meteogram.prototype.drawBlocksForWindArrows = function (chart) {
				var xAxis = chart.xAxis[0],
					x,
					pos,
					max,
					isLong,
					isLast,
					i;

				for (pos = xAxis.min, max = xAxis.max, i = 0; pos <= max + 36e5; pos += 36e5, i += 1) {

					// Get the X position
					isLast = pos === max + 36e5;
					x = Math.round(xAxis.toPixels(pos)) + (isLast ? 0.5 : -0.5);

					// Draw the vertical dividers and ticks
					if (this.resolution > 36e5) {
						isLong = pos % this.resolution === 0;
					} else {
						isLong = i % 2 === 0;
					}
					chart.renderer.path(['M', x, chart.plotTop + chart.plotHeight + (isLong ? 0 : 28),
						'L', x, chart.plotTop + chart.plotHeight + 32, 'Z'])
						.attr({
							'stroke': chart.options.chart.plotBorderColor,
							'stroke-width': 1
						})
						.add();
				}
			};

			Meteogram.prototype.getTitle = function () {
				return this.xml.location.name + ', ' + this.xml.location.country + '<br>';
			};

			<?php
				if($theme=="dark"){
					$innerGraph = "#fff";
				}
				else{
					$innerGraph = "#000";
				}
			?>
			Meteogram.prototype.getChartOptions = function () {
				var meteogram = this;

				return {
					chart: {
						renderTo: this.container,
						marginBottom: 70,
						marginRight: 40,
						marginTop: 50,
						plotBorderWidth:0,
						alignTicks: false,
						backgroundColor: "none",
					},

					title: {
						text: this.getTitle(),
						align: 'center',
						style: {
							color: "<?php echo $innerGraph?>",
						}
					},

					credits: {
						text: '<?php echo lang('data source','c')?> <a href="http://yr.no" target="_blank">yr.no</a>',
						href: this.xml.credit.link['@attributes'].url,
						position: {
							x: -40
						}
					},

					tooltip: {
						shared: true,
						useHTML: true,
						formatter: function () {
							return meteogram.tooltipFormatter(this);
						}
					},

					xAxis: [{ // Bottom X axis
						type: 'datetime',
						style: {
							color: "<?php echo $innerGraph?>",
						},
						tickInterval: 2 * 36e5, // two hours
						minorTickInterval: 36e5, // one hour
						tickLength:1,
						gridLineWidth: 0,
						gridLineColor: '<?php echo $innerGraph?>',
						startOnTick: false,
						endOnTick: false,
						minPadding: 0,
						maxPadding: 0,
						lineColor: '<?php echo $innerGraph?>',
						minorGridLineColor: '#888888',
						tickColor: '<?php echo $innerGraph?>',
						offset: 30,
						showLastLabel: true,
						labels: {
							format: '{value:%H}',
							style: {
								color: "<?php echo $innerGraph?>",
							},
						}
					}, { // Top X axis
						linkedTo: 0,
						type: 'datetime',
						tickInterval: 24 * 3600 * 1000,
						labels: {
							format: '{value:<span style="font-size: 12px; font-weight: bold">%a</span> %b %e}',
							align: 'left',
							x: 3,
							y: -5,
							style: {
								color: "<?php echo $innerGraph?>",
							},
						},
						opposite: true,
						tickLength: 20,
						gridLineWidth: 0,
						gridLineColor: '<?php echo $innerGraph?>',
					}],

					yAxis: [{ // temperature axis
						title: {
							text: null
						},
						labels: {
							format: '{value}',
							style: {
								color: "<?php echo $innerGraph?>",
							},
							x: -16
						},
						plotLines: [{ // zero plane
							value: 0,
							color: '<?php echo $innerGraph?>',
							width: 0,
							zIndex: 2,
						}],
						// Custom positioner to provide even temperature ticks from top down
						tickPositioner: function () {
							var max = Math.ceil(this.max) + 1,
								pos = max - 12, // start
								ret;

							if (pos < this.min) {
								ret = [];
								while (pos <= max) {
									ret.push(pos += 1);
								}
							} // else return undefined and go auto

							return ret;

						},
						maxPadding: 0.3,
						tickInterval: 1,
						gridLineColor: '<?php echo $innerGraph?>'

					}, { // precipitation axis
						title: {
							text: null
						},
						labels: {
							enabled: false
						},
						gridLineWidth: 0,
						tickLength: 0

					}, { 
						allowDecimals: false,
						title: {
							text: '<?php echo $displayPressUnits?>',
							offset: 0,
							align: 'high',
							rotation: 0,
							style: {
								fontSize: '1em',
								color:  '<?php echo $innerGraph?>',
							},
							textAlign: 'left',
							x: 13
						},
						labels: {
							style: {
								fontSize: '1em',
								color:  '<?php echo $innerGraph?>',
							},
							y: 2,
							x: 13
						},
						gridLineWidth: 0,
						opposite: true,
						showLastLabel: false,
						gridLineColor: '<?php echo $innerGraph?>'
					}],

					legend: {
						itemMarginBottom:-20,
						margin:40,
						style: {
							color: "<?php echo $innerGraph?>",
						},
					},

					plotOptions: {
						series: {
							pointPlacement: 'between'
						}
					},


					series: [{
						name: '<?php echo lang('temperature','c')?>',
						data: this.temperatures,
						type: 'spline',
						marker: {
							enabled: false,
							states: {
								hover: {
									enabled: true
								}
							}
						},
						tooltip: {
							valueSuffix: '°<?php echo $displayTempUnits?>'
						},
						zIndex: 1,
						color: '<?php echo $innerGraph?>',
						negativeColor: '<?php echo $innerGraph?>'
					}, {
						name: '<?php echo lang('precipitation','c')?>',
						data: this.precipitations,
						type: 'column',
						color: '#<?php echo $color_schemes[$design2]['400']?>',
						yAxis: 1,
						groupPadding: 0,
						pointPadding: 0,
						borderWidth: 0,
						shadow: false,
						dataLabels: {
							enabled: true,
							formatter: function () {
								if (this.y > 0) {
									return this.y;
								}
							},
							style: {
								fontSize: '1em'
							}
						},
						tooltip: {
							valueSuffix: '<?php echo $displayRainUnits?>'
						}
					}, {
						name: '<?php echo lang('pressure','c')?>',
						color:  '#<?php echo $color_schemes[$design2]['200']?>',
						data: this.pressures,
						marker: {
							enabled: false
						},
						shadow: false,
						tooltip: {
							valueSuffix: ' <?php echo $displayPressUnits?>'
						},
						dashStyle: 'shortdot',
						yAxis: 2
					}]
				};
			};
			Meteogram.prototype.onChartLoad = function (chart) {

				this.drawWeatherSymbols(chart);
				this.drawWindArrows(chart);
				this.drawBlocksForWindArrows(chart);

			};
			Meteogram.prototype.createChart = function () {
				var meteogram = this;
				this.chart = new Highcharts.Chart(this.getChartOptions(), function (chart) {
					meteogram.onChartLoad(chart);
				});
			};
			Meteogram.prototype.parseYrData = function () {

				var meteogram = this,
					xml = this.xml,
					pointStart;

				if (!xml || !xml.forecast) {
					$('#loading').html('<i class="fa fa-frown-o"></i> Failed loading data, please try again later');
					return;
				}
				$.each(xml.forecast.tabular.time, function (i, time) {
					var from = time['@attributes'].from + '',
						to = time['@attributes'].to + '';
					from = from.replace(/-/g, '/').replace('T', ' ');
					from = Date.parse(from);
					to = to.replace(/-/g, '/').replace('T', ' ');
					to = Date.parse(to);

					if (to > pointStart + 4 * 24 * 36e5) {
						return;
					}
					if (i === 0) {
						meteogram.resolution = to - from;
					}
					meteogram.symbols.push(time.symbol['@attributes']['var'].match(/[0-9]{2}[dnm]?/)[0]);
					meteogram.symbolNames.push(time.symbol['@attributes'].name);

					meteogram.temperatures.push({
						x: from,
						<?php 
							if($displayTempUnits=="C"){
								echo "y: parseInt(time.temperature['@attributes'].value, 10),";
							}
							if($displayTempUnits=="F"){
								echo "y: Math.round((parseInt(time.temperature['@attributes'].value, 10)*1.8)+32),";
							}
						?>					
						to: to,
						index: i
					});

					meteogram.precipitations.push({
						x: from,
						<?php
							if($displayRainUnits=="mm"){
								echo "y: parseFloat(time.precipitation['@attributes'].value)";
							}
							if($displayRainUnits=="in"){
								echo "y: Math.round(parseFloat(time.precipitation['@attributes'].value)*0.0393701*100)/100";
							}
						?>
						
					});
					meteogram.windDirections.push(parseFloat(time.windDirection['@attributes'].deg));
					meteogram.windDirectionNames.push(time.windDirection['@attributes'].name);
					<?php
						if($displayWindUnits=="ms"){
							echo "meteogram.windSpeeds.push(parseFloat(time.windSpeed['@attributes'].mps));";
						}
						if($displayWindUnits=="kmh"){
							echo "meteogram.windSpeeds.push(Math.round(parseFloat(time.windSpeed['@attributes'].mps)*3.6*10)/10);";
						}
						if($displayWindUnits=="mph"){
							echo "meteogram.windSpeeds.push(Math.round(parseFloat(time.windSpeed['@attributes'].mps)*2.23694*10)/10);";
						}
						if($displayWindUnits=="kt"){
							echo "meteogram.windSpeeds.push(Math.round(parseFloat(time.windSpeed['@attributes'].mps)*1.943844*10)/10);";
						}
					?>				
					meteogram.windSpeedNames.push(time.windSpeed['@attributes'].name);
					meteogram.pressures.push({
						x: from,
						<?php 
							if($displayPressUnits=="hpa"){
								echo "y: parseFloat(time.pressure['@attributes'].value)";
							}
							if($displayPressUnits=="inhg"){
								echo "y: Math.round(parseFloat(time.pressure['@attributes'].value)*0.0295299830714*100)/100";
							}
							if($displayPressUnits=="mmhg"){
								echo "y: Math.round(parseFloat(time.pressure['@attributes'].value)*0.75006375541921)";
							}
						?>
					});

					if (i === 0) {
						pointStart = (from + to) / 2;
					}
				});
				this.smoothLine(this.temperatures);
				this.createChart();
			};
			loadMeteogramBlock();
			function loadMeteogramBlock(){
				idLocation = $("#idLocation").val();
				$.getJSON(
					'dataLoader.php?callback=?&id='+idLocation,
					function (xml) {
						window.meteogram = new Meteogram(xml, 'container');
					}
				);
			}
			$("#idLocation").change(function(){
				loadMeteogramBlock();
			});
		</script>
	</body>
</html>