<?php
	
	# 		Moon phases block
	# 		Namespace:		moonPhase
	#		Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness
	#			- bug fixes
	#		v1.2 - Jul 06, 2016
	#			- fixed icons
	# 		v2.0 - Feb 28, 2017
	# 			- added block heading
	# 			- added remaining time
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../scripts/functions.php");

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	$mp = new moonPhase(time());
	$img_phase = $mp->getPositionInCycle();
	$intervals = 118;
	$moonIcon = round(($img_phase/(1/$intervals)));
	$moonIllumination = $mp->getPercentOfIllumination();
	
	$output['moonIcon'] = $moonIcon;
	$output['moonIllumination'] = $moonIllumination;
	
	$stationTimezone = new DateTimeZone($stationTZ);
	$stationOffset  = $stationTimezone->getOffset(new DateTime)/3600;
	
	// get Moons
	$moonFile = fopen("files/moons.txt", "r"); // load the Moon data
	while(!feof($moonFile)) {
		$newRecord = explode(",",fgets($moonFile)); // process line
		$phase = $newRecord[3]; // get phase
		$timestamp = $newRecord[5]; // get timestamp
		if($timestamp>=time()){ // fetch only records in the future
			if($phase==3){
				$fullMoons[] = date($dateTimeFormat,$timestamp);
			}
			if($phase==2){
				$firstQuarters[] = date($dateTimeFormat,$timestamp);
			}
			if($phase==4){
				$lastQuarters[] = date($dateTimeFormat,$timestamp);
			}
			if($phase==1){
				$newMoons[] = date($dateTimeFormat,$timestamp);
			}
		}
		if(date("Ymd",$timestamp) == date("Ymd")){ // check if it is today
			$moonToday = array($phase,$timestamp); // if some phase is today, log it
		}	
	}
	fclose($moonFile);
	
	$output['fullMoons'] = $fullMoons;
	$output['newMoons'] = $newMoons;
	$output['firstQuarters'] = $firstQuarters;
	$output['lastQuarters'] = $lastQuarters;

	$diff['fullMoon'] = dateDiff(time(),strtotime($output['fullMoons'][0]));
	$diff['newMoon'] = dateDiff(time(),strtotime($output['newMoons'][0]));
	$diff['firstQuarter'] = dateDiff(time(),strtotime($output['firstQuarters'][0]));
	$diff['lastQuarter'] = dateDiff(time(),strtotime($output['lastQuarters'][0]));

	function dateDiff($time1, $time2, $precision = 6) {
		if (!is_int($time1)) {
		  $time1 = strtotime($time1);
		}
		if (!is_int($time2)) {
		  $time2 = strtotime($time2);
		}
		if ($time1 > $time2) {
		  $ttime = $time1;
		  $time1 = $time2;
		  $time2 = $ttime;
		}
		$intervals = array('year','month','day','hour','minute','second');
		$diffs = array();
		foreach ($intervals as $interval) {
		  $ttime = strtotime('+1 ' . $interval, $time1);
		  $add = 1;
		  $looped = 0;
		  while ($time2 >= $ttime) {
			$add++;
			$ttime = strtotime("+" . $add . " " . $interval, $time1);
			$looped++;
		  }
		  $time1 = strtotime("+" . $looped . " " . $interval, $time1);
		  $diffs[$interval] = $looped;
		}
		$count = 0;
		$times = array();
		foreach ($diffs as $interval => $value) {
		  if ($count >= $precision) {
			break;
		  }
		  if ($value > 0) {
			$times[] = $value . " " . $interval;
			$count++;
		  }
		}
		$result = implode(" ", $times);
		$result = str_replace("year","y",$result);
		$result = str_replace("month","m",$result);
		$result = str_replace("day","d",$result);
		$result = str_replace("hour","h",$result);
		$result = str_replace("minute","min",$result);
		$result = str_replace("second","s",$result);
		return $result;
	}
?>
	<style>
		.moonPhaseImg{
			max-width: 30px;
			width: 100%;
		}
		<?php
			if($stationLat<0){
		?>
			#moonPhaseImg{
				-webkit-transform: rotate(-180deg);
				-moz-transform: rotate(-180deg);
				-ms-transform: rotate(-180deg);
				-o-transform: rotate(-180deg);
				filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=6);
			}
		<?php
			}
		?>
	</style>
	<h2><?php echo lang('moon phase','c')?></h2>
	<table style="width:100%">
		<tr>
			<td>
				<img src="<?php echo $pageURL.$path?>imgs/moon/<?php echo $output['moonIcon']?>.png" style="max-width:50px;width:100%;padding-top:3px;padding-bottom:3px" id="moonPhaseImg" alt='' class="tooltip" title="<?php echo lang('moon phase','c')?>">
			</td>
			<td>
				<?php echo $output['moonIllumination']?>
			</td>
		</tr>
		<tr>
			<td>
				<img src="homepage/blocks/moonPhase/icons/<?php echo $theme?>/fullMoon.png" alt='' class="moonPhaseImg tooltip" title="<?php echo lang('Full','c')?>">
				<br>
				<strong><?php echo $output['fullMoons'][0]?></strong><br><span style="font-variant:small-caps;font-size:0.9em"><?php echo $diff['fullMoon']?></span>
			</td>
			<td>
				<img src="homepage/blocks/moonPhase/icons/<?php echo $theme?>/newMoon.png" alt='' class="moonPhaseImg tooltip" title="<?php echo lang('New moon','c')?>">
				<br>
				<strong><?php echo $output['newMoons'][0]?></strong><br><span style="font-variant:small-caps;font-size:0.9em"><?php echo $diff['newMoon']?></span>
			</td>
		</tr>
	</table>
	<div id="moonPhases1" style="display:none">
	<table style="width:100%">
		<tr>
			<td>
				<?php 
					for($i=1;$i<13;$i++){
						echo $output['fullMoons'][$i]."<br>";
					}
				?>
			</td>
			<td>
				<?php 
					for($i=1;$i<13;$i++){
						echo $output['newMoons'][$i]."<br>";
					}
				?>
			</td>
		</tr>
	</table>
	</div>
	<span class="more" onclick="txt = $('#moonPhases1').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#moonPhases1').slideToggle(800);$(this).text(txt)">
		<?php echo lang('more','l')?>
	</span>
	<table style="width:100%">
	<tr>
		<td>
			<?php
				if($stationLat>=0){
					echo "<img src='homepage/blocks/moonPhase/icons/".$theme."/halfMoon2.png' alt='' class='moonPhaseImg tooltip' title='".lang('First quarter','c')."'>";
				}
				else{
					echo "<img src='homepage/blocks/moonPhase/icons/".$theme."/halfMoon.png' alt='' class='moonPhaseImg tooltip' title='".lang('First quarter','c')."'>";
				}
			?>
			<br>
			<strong><?php echo $output['firstQuarters'][0]?></strong><br><span style="font-variant:small-caps;font-size:0.9em"><?php echo $diff['firstQuarter']?></span>
		</td>
		<td>
			<?php
				if($stationLat>=0){
					echo "<img src='homepage/blocks/moonPhase/icons/".$theme."/halfMoon.png' style='width:30px' alt='' class='moonPhaseImg tooltip' title='".lang('Third quarter','c')."'>";
				}
				else{
					echo "<img src='homepage/blocks/moonPhase/icons/".$theme."/halfMoon2.png' alt='' class='moonPhaseImg tooltip' title='".lang('Third quarter','c')."'>";
				}
			?>
			<br>
			<strong><?php echo $output['lastQuarters'][0]?></strong><br><span style="font-variant:small-caps;font-size:0.9em"><?php echo $diff['lastQuarter']?></span>
		</td>
	</tr>
	</table>
	<div id="moonPhases2" class="details">
	<table style="width:100%">
			<tr>
				<td>
					<?php 
						for($i=1;$i<13;$i++){
							echo $output['firstQuarters'][$i]."<br>";
						}
					?>
				</td>
				<td>
					<?php 
						for($i=1;$i<13;$i++){
							echo $output['lastQuarters'][$i]."<br>";
						}
					?>
				</td>
			</tr>
	</table>
	</div>
	<span class="more" onclick="txt = $('#moonPhases2').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#moonPhases2').slideToggle(800);$(this).text(txt)">
		<?php echo lang('more','l')?>
	</span>