<?php

	# 		NASA Image of the day
	# 		Namespace:		nasaImg
	#		Meteotemplate Block

	# 		v1.0 - Jan 23, 2016
	# 			- initial release
	# 		v2.0 - Apr 21, 2017
	# 			- translation
	# 			- zoom feature
	
	include("settings.php");
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	$xml = json_decode(json_encode((array) simplexml_load_file("https://www.nasa.gov/rss/dyn/lg_image_of_the_day.rss")),1);
	
	// count images
	$imgCount = count($xml['channel']['item']);
	if($images=="random"){
		$imgRandom = rand(0,$imgCount);
	}
	if($images=="today"){
		$imgRandom = 0;
	}
	$title = $xml['channel']['item'][$imgRandom]['title'];
	$desc = $xml['channel']['item'][$imgRandom]['description'];
	$imgLink = $xml['channel']['item'][$imgRandom]['enclosure']['@attributes']['url'];
?>
	<style>
		#mainNasaImg{
			width:100%; 
			border: 2px solid #<?php echo $color_schemes[$design2]['500']?>;
			border-radius:10px;
			cursor: pointer;
		}
	</style>
	<h2 style="font-size:1.1em">NASA <?php echo lang('image of the day',"c")?></h2>
	<div style="width:90%;margin:0 auto;padding-top:3px;padding-bottom:4px">
		<img src="<?php echo $imgLink?>" style="" id="mainNasaImg">
	</div>
	<div id="nasaImgWindow"></div>
	<?php echo $title?>
	<script>
		$("#mainNasaImg").click(function(){
			urlImg = $("#mainNasaImg").attr('src');
			$("#nasaImgWindow").html("<div style='width:98%;margin:0 auto;text-align:center'><img src='"+urlImg+"' style='width:100%'></div>");
			$("#nasaImgWindow").dialog('open');		
		})
		dialogHeight = screen.height*0.98;
		dialogWidth = screen.width*0.98;
		$("#nasaImgWindow").dialog({
			modal: true,
			autoOpen: false,
			height: dialogHeight,
			width: dialogWidth
		});
	</script>