<?php 

	include("../../../config.php");
	include($baseURL."css/design.php");
	include($baseURL."header.php");
	
	// check acces authorization
	session_start();
	if($_SESSION['user']!="admin"){
		echo "Unauthorized access.";
		die();
	}
	
	$feedItems = array();
	
	if(file_exists("feedItems.txt")){
		$feedItems = file_get_contents("feedItems.txt");
		$feedItems = json_decode($feedItems,true);
	}
?>
<!DOCTYPE html>
<html>
	<head>
		<title>Edit news feed</title>
		<?php metaHeader()?>
		<style>

		</style>
	</head>
	<body>
		<div id="main_top">
			<?php bodyHeader()?>
			<?php include($baseURL."menu.php")?>
		</div>
		<div id="main" style="text-align:left">
			<div style="margin:0 auto;width:90%">
			<h1>News Feed</h1>
			<h3>Current items</h3>
			<?php
				if(count($feedItems)==0){
					echo "<br>No items<br>";
				}
				else{
					echo "<table style='width:100%'>";
					for($i=0;$i<count($feedItems);$i++){
			?>
						<tr>
							<td style="width:80%;text-align:justify">
								<ul>
									<li>
										<?php echo $feedItems[$i]?>
									</li>
								</ul>
							</td>
							<td>
								<input type="button" id="<?php echo "delete".$i?>" class="button2 deleteItem" value="Delete">
							</td>
						</tr>
			<?php
					}
					echo "</table>";
				}
			?>
			<br>
			<h3>New</h3>
			<form action="save.php" method="post">
				<textarea id="text" name="text" style="width:30%;text-align:left" class="button2"></textarea>
				<br>
				<input type="submit" value="Save" name="submit" class="button">
			</form>
			

			</div>
		</div>
		<?php include($baseURL."footer.php")?>
		<script>
			$(".deleteItem").click(function(){
				pass = $("#adminPass").val();
				if(pass==""){
					alert("Fill in your admin password");
					return false;
				}
				var r = confirm("Do you really want to delete the item?");
				if(r){
					ID = $(this).attr("id");
					window.location = "delete.php?id="+ID+"&password="+pass;
				}
			})
		</script>
	</body>
</html>