<?php

	# 		Ozone Forecast
	# 		Namespace:		ozoneForecast
	#		Meteotemplate Block
	
	$version = 1.0;
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	$monthNames = array(0,lang('janAbbr','c'), lang('febAbbr','c'), lang('marAbbr','c'), lang('aprAbbr','c'), lang('mayAbbr','c'), lang('junAbbr','c'), lang('julAbbr','c'), lang('augAbbr','c'), lang('sepAbbr','c'),  lang('octAbbr','c'), lang('novAbbr','c'), lang('decAbbr','c'));
	
	$weekDays = array(lang('sundayAbbr','c'),lang('mondayAbbr','c'),lang('tuesdayAbbr','c'),lang('wednesdayAbbr','c'),lang('thursdayAbbr','c'),lang('fridayAbbr','c'),lang('saturdayAbbr','c'));
	
	$infoArray = array(2,5,7,9,12);
	$infoIntervals = array("0 - 2.9","3 - 5.9","6 - 7.9","8 - 10.9","> 11");
	
	$url = "http://www.temis.nl/uvradiation/nrt/uvindex.php?lon=".$stationLon."&lat=".$stationLat;
	
	if(file_exists("cache/o3.txt")){ 
		if (time()-filemtime("cache/o3.txt") > 60 * 360) {
			unlink("cache/o3.txt");
		}
	}
	if(file_exists("cache/o3.txt")){
		$forecastRaw = file_get_contents("cache/o3.txt");
	}
	else { 
		$forecastRaw = getData($url);
		$save = file_put_contents("cache/o3.txt",$forecastRaw);
	}
	
	$forecastRaw = preg_replace("/\n/", "", $forecastRaw);
	$forecastRaw = preg_replace('/\s+/', ' ', $forecastRaw);
	
	preg_match("/<\!-- main body of the page -->(.*?)<\!-- empty separation column -->/",$forecastRaw,$matches);
	if(array_key_exists(1,$matches)){
			$forecastDiv = $matches[1];
			preg_match_all('/(.*?)([0-9][0-9]?[0-9]?.[0-9]?( )?DU)/',$forecastDiv,$matchesOzone);	
			if(array_key_exists(2,$matchesOzone)){
				$ozoneForecast = $matchesOzone[2];
			}
			else{
				$ozoneForecast[] = "Forecast N/A";
			}
			preg_match_all('/([0-9][0-9]? [A-Z][a-z][a-z] [0-9][0-9][0-9][0-9])/',$forecastDiv,$matchesDates);	
			if(array_key_exists(1,$matchesDates)){
				$dates = $matchesDates[1];
			}
			else{
				$dates[] = "Forecast N/A";
			}
	}
	
	function getData($url){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_URL, $url);
		$data = curl_exec($ch);
		curl_close($ch);
		return $data;
	}
?>
	<style>
		
	</style>
	<div style="width:100%;text-align:center;padding-bottom:5px">
		<img src="homepage/blocks/ozoneForecast/icons/<?php echo $theme?>/o3.png" style="width:100%;max-width:50px">
	</div>
	<table style="width:98%;margin:0 auto" class="table">
		<?php
			for($i=0;$i<count($dates);$i++){
				$date = strtotime($dates[$i]);
				$difference = null;
				if(array_key_exists($i-1,$ozoneForecast)){
					$difference = $ozoneForecast[$i] - $ozoneForecast[$i-1];
					if($difference>0){
						$diffImg = "trendUp";
					}
					if($difference<0){
						$diffImg = "trendDown";
					}
					if($difference==0){
						$diffImg = "trendNeutral";
					}
				}
		?>
			<tr>
				<td style="width:30%;font-variant:small-caps;padding:3px;width:20%">
					<span style="font-weight:bold;font-size:1.5em"><?php echo date("j",$date)?></span> <?php echo $weekDays[date('w',$date)]?>
				</td>
				<td style="text-align:right">
					<?php
						if($difference!==null){
							echo "<img src='homepage/blocks/ozoneForecast/icons/".$theme."/".$diffImg.".png' style='width:100%;max-width:25px'>";
						}
					?>
				</td>
				<td style="text-align:right;padding-right:5px;width:30%">
					<?php echo ($ozoneForecast[$i])?>
				</td>
			</tr>
		<?php
			}
		?>
	</table>
	
	<div id="ozoneForecastInfo" class="details">
		<br>
		<div style="width:98%;margin:0 auto;text-align:justify;font-size:0.85em">
			<ul>
				<li>
					Dobson unit (DU) is a unit of measurement of the columnar density of a trace gas in the Earth's atmosphere.
				</li>
				<li>
					DU is given as the thickness (in units of 10 µm) of that layer which would be formed by the total gas in a column under standard temperature and pressure.
				</li>
				<li>
					a baseline value of 220 DU is chosen as the starting point for an ozone hole since total ozone values of less than 220 Dobson units were not found in the historic observations over Antarctica prior to 220.
				</li>
			</ul>
		</div>
		<span style="font-size:0.85em;font-variant:small-caps"><?php echo lang("data source","c")?>: temis.nl. Used with permission.</span>
	</div>
	<table style="width:100%">
		<tr>
			<td style="width:50%;text-align:center">
				<span class="more" onclick="txt = $('#ozoneForecastInfo').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#ozoneForecastInfo').slideToggle(800);$(this).text(txt);"><?php echo lang('more','l')?></span>
			</td>
		</tr>
	</table>
	