<?php

	# 		PayPal block
	# 		Namespace:		payPal
	#		Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness

	# 		v2.0 - Jun 1, 2017
	# 			- added possibility to use an icon
	# 			- added possibility to include text
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../scripts/functions.php");

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}

?>
	<style>
		#payPalIcon{
			font-size: 2em;
			opacity: 0.8;
			cursor: pointer;
			padding-top: 7px;
		}
		#payPalIcon:hover{
			opacity:1;
		}
	</style>
	<?php 
		if($payPalType=="button"){
	?>
			<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="blank">
				<input type="hidden" name="cmd" value="_s-xclick">
				<input type="hidden" name="hosted_button_id" value="<?php echo $paypalButtonCode?>">
				<input type="image" src="https://www.paypalobjects.com/en_US/i/btn/btn_donateCC_LG.gif" style="border:none;max-width:120px;width:100%;padding:3px" name="submit" alt="PayPal">
				<img alt="" style="border:none;width:1px;height:1px" src="https://www.paypalobjects.com/en_US/i/scr/pixel.gif">
			</form>
	<?php
		}
	?>
	<?php 
		if($payPalType=="icon"){
	?>
			<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="blank" id="thisPayPalForm">
				<input type="hidden" name="cmd" value="_s-xclick">
				<input type="hidden" name="hosted_button_id" value="<?php echo $paypalButtonCode?>">
				<span class="fa fa-paypal" id="payPalIcon" onclick="$('#thisPayPalForm').submit()"></span>
				<img alt="" style="border:none;width:1px;height:1px" src="https://www.paypalobjects.com/en_US/i/scr/pixel.gif">
			</form>
	<?php
		}
	?>
	<?php 
		if($payPalText!=""){
	?>
			<br>
			<div class="details" id="payPalMore" style="width:95%;padding-bottom:5px;text-align:justify;margin:0 auto">
				<?php echo $payPalText?>
			</div>
			<span id="payPalMoreOpener" class="more" onclick="txt = $('#payPalMore').is(':visible') ? '<?php echo lang('info','l')?>' : '<?php echo lang('hide','l')?>';$('#payPalMore').slideToggle(800);$(this).text(txt)">
					<?php echo lang('info','l')?>
			</span>
	<?php
		}
	?>

	