<?php

	# 		Radar Europe
	# 		Namespace:		radarEU
	#		Meteotemplate Block
	
	# 		v2.0 - Jul 13, 2016
	#			- possibility to zoom in images in a dialog popup
	# 		v2.1 - Jul 26, 2016
	#			- bug fixes
	# 		v3.0 - Feb 19, 2017
	# 			- redesign
	# 			- new data source
	# 		v3.1 - Jul 10, 2017
	# 			- compatibility tweaks
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");

	//error_reporting(E_ALL);

	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	$euURL = "https://api.sat24.com/animated/EU/rainTMC/3/Coordinated%20Universal%20Time/".time();
	$euRegionalURL = "https://api.sat24.com/crop?type=rainTMC&lat=".$stationLat."&lon=".$stationLon."&width=754&height=550&zoom=1.00&continent=eu&timestamp=".time();

?>
	<style>
		.euRadarImg{
			width: 98%;
			margin: 0 auto;
			border-radius: 10px;
			cursor: pointer;
			opacity: 0.8;
			border: 1px solid #<?php echo $theme=="dark" ? $color_schemes[$design2]['300'] : $color_schemes[$design2]['700']?>;
		}
		.euRadarImg:hover{
			opacity: 1;
		}
	</style>
	<table style="width:100%">
		<tr>
			<td style="width:50%">
				<img id="radarEUMain" src="<?php echo $euURL?>" class="euRadarImg">
			</td>
			<td style="width:50%">
				<img id="radarEURegional" src="<?php echo $euRegionalURL?>" class="euRadarImg">
			</td>
		</tr>
		<tr>
			<td colspan="2">
				<select class="button2" id="euRadarSelector">
					<option value="rain"><?php echo lang('rain','c')?></option>
					<option value="cloudiness"><?php echo lang('cloudiness','c')?></option>
					<option value="infrared"><?php echo lang('infrared','c')?></option>
					<option value="snow"><?php echo lang('snow','c')?></option>
				</select>
			</td>
		</tr>
	</table>
	<div style='width:98%;margin:0 auto;text-align:center;font-size:0.7em;font-variant:small-caps;padding-top:10px'>
		<?php echo lang("data source",'c')?>: Sat24
	</div>
	<div id="euRadarWindow"></div>
	<script>
		$(".euRadarImg").click(function(){
			urlRadar = $(this).attr('src');
			$("#euRadarWindow").html("<div style='width:98%;margin:0 auto;text-align:center;'><img src='"+urlRadar+"' style='width:100%'></div>");
			$("#euRadarWindow").dialog('open');	
		})
		dialogHeight = screen.height*0.8;
		dialogWidth = screen.width*0.6;
		$("#euRadarWindow").dialog({
			modal: true,
			autoOpen: false,
			height: dialogHeight,
			width: dialogWidth
		});
		$("#euRadarSelector").change(function(){
			val = $(this).val();
			rand = Math.round(Math.random());
			if(val=="rain"){
				$("#radarEUMain").attr("src","https://api.sat24.com/animated/EU/rainTMC/3/Coordinated%20Universal%20Time/"+ rand);
				$("#radarEURegional").attr("src","https://api.sat24.com/crop?type=rainTMC&lat=<?php echo $stationLat?>&lon=<?php echo $stationLon?>&width=754&height=550&zoom=1.00&continent=eu&ts="+ rand);
			}
			if(val=="cloudiness"){
				$("#radarEUMain").attr("src","https://api.sat24.com/animated/EU/visual/3/Coordinated%20Universal%20Time/"+ rand);
				$("#radarEURegional").attr("src","https://api.sat24.com/crop?type=visual5hdcomplete&lat=<?php echo $stationLat?>&lon=<?php echo $stationLon?>&width=754&height=550&zoom=1.00&continent=eu&ts="+ rand);
			}
			if(val=="infrared"){
				$("#radarEUMain").attr("src","https://api.sat24.com/animated/EU/infraPolair/3/Coordinated%20Universal%20Time/"+ rand);
				$("#radarEURegional").attr("src","https://api.sat24.com/crop?type=infraPolair&lat=<?php echo $stationLat?>&lon=<?php echo $stationLon?>&width=754&height=550&zoom=1.00&continent=eu&ts="+ rand);
			}
			if(val=="snow"){
				$("#radarEUMain").attr("src","https://api.sat24.com/animated/EU/snow/3/Coordinated%20Universal%20Time/"+ rand);
				$("#radarEURegional").attr("src","https://api.sat24.com/crop?type=snow&lat=<?php echo $stationLat?>&lon=<?php echo $stationLon?>&width=754&height=550&zoom=1.00&continent=eu&ts="+ rand);
			}
		})
	</script>