<?php
	
	# 		Radar UK
	# 		Namespace:		radarUK
	#		Meteotemplate Block
	
	# 		v1.0 - Sep 13, 2016
	#			- Initial release
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	
	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}	
	
	if(!is_dir("cache")){
		mkdir("cache");
	}
	
	if(file_exists("cache/latestImg.txt")){ 
		if (time()-filemtime("cache/latestImg.txt") > 60 * 14) {
			unlink("cache/latestImg.txt");
		}
	}
	if(file_exists("cache/latestImg.txt")){}
	else{
		if(file_exists("cache/rainfall.png")){
			unlink("cache/rainfall.png");
		}
		$updatedTimes = json_decode(file_get_contents("http://datapoint.metoffice.gov.uk/public/data/layer/wxobs/all/json/capabilities?key=".$METAPIkey),true);
		if(array_key_exists(0,$updatedTimes["Layers"]['Layer'][3]['Service']['Times']['Time'])){
			$latestTime = $updatedTimes["Layers"]['Layer'][3]['Service']['Times']['Time'][0];
			$rainFallURL = "http://datapoint.metoffice.gov.uk/public/data/layer/wxobs/RADAR_UK_Composite_Highres/png?TIME=".$latestTime."Z&key=".$METAPIkey;
			$ch = curl_init($rainFallURL);
			$fp = fopen('cache/rainfall.png', 'wb');
			curl_setopt($ch, CURLOPT_FILE, $fp);
			curl_setopt($ch, CURLOPT_HEADER, 0);
			curl_exec($ch);
			curl_close($ch);
			fclose($fp);
			file_put_contents("cache/latestImg.txt",$latestTime);
		}	
	}

?>
	<style>
		#mapUK{
			width:98%;
			height:500px;
			margin: 0 auto;
		}
	</style>
	<div style="position:relative;width:100%">
		<?php 
			if(file_exists("cache/rainfall.png")){
		?>
				<div id="mapUK"></div>
				<?php 
					echo date($dateTimeFormat,strtotime(file_get_contents("cache/latestImg.txt")."Z"));			
				?>
		<?php 
			}
			else{
				echo "Data currently not available";
			}
		?>
	</div>
	<div style='width:98%;margin:0 auto;text-align:center;font-size:0.7em;font-variant:small-caps;padding-top:10px'>
		Data source: MetOffice
	</div>
	<script>
		<?php 
			if(file_exists("cache/rainfall.png")){
		?>
				var overlay;
				DebugOverlay.prototype = new google.maps.OverlayView();
				function initializeUKRadar() {
					var mapOptions = {
						zoom: 5,
						center: new google.maps.LatLng(55,-3)
					};
					var map = new google.maps.Map(document.getElementById('mapUK'), mapOptions);
						var bounds = new google.maps.LatLngBounds(
						new google.maps.LatLng(48, -12),
						new google.maps.LatLng(61, 5)
					);
					var srcImage = 'homepage/blocks/radarUK/cache/rainfall.png';  
					overlay = new DebugOverlay(bounds, srcImage, map);   
				}
				function DebugOverlay(bounds, image, map) {
				  this.bounds_ = bounds;
				  this.image_ = image;
				  this.map_ = map;
				  this.div_ = null;
				  this.setMap(map);
				}
				DebugOverlay.prototype.onAdd = function() {
				  var div = document.createElement('div');
				  div.style.borderStyle = 'none';
				  div.style.borderWidth = '0px';
				  div.style.position = 'absolute';
				  var img = document.createElement('img');
				  img.src = this.image_;
				  img.style.width = '100%';
				  img.style.height = '100%';
				  img.style.opacity = '0.7';
				  //img.style.position = 'absolute';
				  div.appendChild(img);
				  this.div_ = div;
				  var panes = this.getPanes();
				  panes.overlayLayer.appendChild(div);
				};
				DebugOverlay.prototype.draw = function() {
				  var overlayProjection = this.getProjection();
				  var sw = overlayProjection.fromLatLngToDivPixel(this.bounds_.getSouthWest());
				  var ne = overlayProjection.fromLatLngToDivPixel(this.bounds_.getNorthEast());
				  var div = this.div_;
				  div.style.left = sw.x + 'px';
				  div.style.top = ne.y + 'px';
				  div.style.width = (ne.x - sw.x) + 'px';
				  div.style.height = (sw.y - ne.y) + 'px';
				};
				DebugOverlay.prototype.updateBounds = function(bounds){
					this.bounds_ = bounds;
					this.draw();
				};
				DebugOverlay.prototype.onRemove = function() {
				  this.div_.parentNode.removeChild(this.div_);
				  this.div_ = null;
				};
				initializeUKRadar();
		<?php 
			}
		?>
	</script>