<?php

	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	include("settings.php");
	
	$region = $_GET['region'];
	
	$regionCodes = array();
	$regionCodes['os'] = 500;
	$regionCodes['he'] = 501;
	$regionCodes['gr'] = 502;
	$regionCodes['ta'] = 504;
	$regionCodes['st'] = 503;
	$regionCodes['dg'] = 505;
	$regionCodes['ni'] = 506;
	$regionCodes['yh'] = 509;
	$regionCodes['ne'] = 508;
	$regionCodes['em'] = 511;
	$regionCodes['ee'] = 512;
	$regionCodes['se'] = 514;
	$regionCodes['nw'] = 507;
	$regionCodes['wm'] = 510;
	$regionCodes['sw'] = 513;
	$regionCodes['wl'] = 516;
	
	$regionalURL = "http://datapoint.metoffice.gov.uk/public/data/txt/wxfcs/regionalforecast/json/".$regionCodes[$region]."?key=".$metOfficeAPI;
	
	$dataRegionalRaw = curl_get_contents($regionalURL);
	
	$dataRegional = json_decode($dataRegionalRaw,true);
	
	function curl_get_contents($url){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_URL, $url);
		$data = curl_exec($ch);
		curl_close($ch);
		return $data;
	}
	
	foreach($dataRegional['RegionalFcst']['FcstPeriods']['Period'] as $period){
		$paragraph = $period['Paragraph'];
		if(array_key_exists('title',$paragraph)){
			echo "<span style='font-weight:bold;font-size:1.1em;color:#".$color_schemes[$design2]['200']."'>".str_replace(':','',$paragraph['title'])."</span><br>";
			echo $paragraph['$'];
			echo "<br><br>";
		}
		else{
			foreach ($paragraph as $item){
				if($item['title']=="Headline:"){
					echo "<span style='font-weight:bold;font-variant:small-caps;font-size:1.4em'>".$item['$']."</span>";
				}
				else{
					echo "<span style='font-weight:bold;font-size:1.1em;color:#".$color_schemes[$design2]['200']."'>".str_replace(':','',$item['title'])."</span><br>";
					echo $item['$'];
				}
				
				echo "<br><br>";
			}
		}
	}
	?>