<?php

	# 		UK regional forecast
	# 		Namespace:		regionalUK
	#		Meteotemplate Block
	
	# 		v2.0 - Aug 10, 2016
	#			- possibility to view other regions
	
		
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];
	
	include("../../../config.php");
	include("../../../css/design.php");
	include("../../../scripts/functions.php");
	
	include("settings.php");
	
	if($metOfficeAPI==""){
		echo "Specify your MetOffice API key in settings.php";
		die();
	}
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);
	
	$regionCodes = array();
	$regionCodes['os'] = 500;
	$regionCodes['he'] = 501;
	$regionCodes['gr'] = 502;
	$regionCodes['ta'] = 504;
	$regionCodes['st'] = 503;
	$regionCodes['dg'] = 505;
	$regionCodes['ni'] = 506;
	$regionCodes['yh'] = 509;
	$regionCodes['ne'] = 508;
	$regionCodes['em'] = 511;
	$regionCodes['ee'] = 512;
	$regionCodes['se'] = 514;
	$regionCodes['nw'] = 507;
	$regionCodes['wm'] = 510;
	$regionCodes['sw'] = 513;
	$regionCodes['wl'] = 516;
	
	$regionNames = array();
	$regionNames['os'] = 'Orkney & Shetland';
	$regionNames['he'] = 'Highland & Eilean Siar';
	$regionNames['gr'] = 'Grampian';
	$regionNames['ta'] = 'Tayside';
	$regionNames['st'] = 'Strathclyde';
	$regionNames['dg'] = 'Dumfries, Galloway, Lothian';
	$regionNames['ni'] = 'Northern Ireland';
	$regionNames['yh'] = 'Yorkshire & the Humber';
	$regionNames['ne'] = 'Northeast England';
	$regionNames['em'] = 'East Midlands';
	$regionNames['ee'] = 'East of England';
	$regionNames['se'] = 'London & Southeast England';
	$regionNames['nw'] = 'Northwest England';
	$regionNames['wm'] = 'West Midlands';
	$regionNames['sw'] = 'Southwest England';
	$regionNames['wl'] = 'Wales';
	
	$ukURL = "http://datapoint.metoffice.gov.uk/public/data/txt/wxfcs/regionalforecast/json/515?key=".$metOfficeAPI;
	$regionalURL = "http://datapoint.metoffice.gov.uk/public/data/txt/wxfcs/regionalforecast/json/".$regionCodes[$region]."?key=".$metOfficeAPI;
	
	if(file_exists("cache/dataUK.txt")){
		if (time()-filemtime("cache/dataUK.txt") > 60 * 60) {
			unlink("cache/dataUK.txt");
		}
		else if(strlen(file_get_contents("cache/dataUK.txt"))<5){
			unlink("cache/dataUK.txt");
		}
		else{}
	}
	if(file_exists("cache/dataUK.txt")){
		$dataUKRaw = file_get_contents("cache/dataUK.txt");	
	}
	else { 
		$dataUKRaw = curl_get_contents($ukURL);
		$save = file_put_contents("cache/dataUK.txt",$dataUKRaw);
	}
	
	if(file_exists("cache/dataRegional.txt")){
		if (time()-filemtime("cache/dataRegional.txt") > 60 * 60) {
			unlink("cache/dataRegional.txt");
		}
		else if(strlen(file_get_contents("cache/dataRegional.txt"))<5){
			unlink("cache/dataRegional.txt");
		}
		else{}
	}
	if(file_exists("cache/dataRegional.txt")){
		$dataRegionalRaw = file_get_contents("cache/dataRegional.txt");	
	}
	else { 
		$dataRegionalRaw = curl_get_contents($regionalURL);
		$save = file_put_contents("cache/dataRegional.txt",$dataRegionalRaw);
	}
	
	$dataUK = json_decode($dataUKRaw,true);
	$dataRegional = json_decode($dataRegionalRaw,true);
	
	function curl_get_contents($url){
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_HEADER, 0);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_URL, $url);
		$data = curl_exec($ch);
		curl_close($ch);
		return $data;
	}
?>
	<style>
		.forecastUKselector{
			font-weight:bold;
			font-size:1.4em;
			font-variant:small-caps;
			opacity: 0.8;
			cursor: pointer;
		}
		.forecastUKselector:hover{
			opacity: 1;
		}
	</style>
	<h2><img src="<?php echo $pageURL.$path?>imgs/flags/big/gb.png" style="width:100%;max-width:70px"><br><?php echo lang("forecast",'c')?></h2>
	<br>
	<table style="width:98%;margin:0 auto;border-spacing:0px;background:#<?php echo $color_schemes[$design2]['800']?>">
		<tr>
			<td style="width:50%;text-align:center;padding:10px" class="forecastUKselector" id="showNationalUK">
				UK
			</td>
			<td class="forecastUKselector" id="showRegionalUK" style="padding:10px">
				<?php echo lang('regional','c')?>
			</td>
		</tr>
	</table>
	<div style="width:98%;padding-top:10px;margin:0 auto;text-align:justify;background:#<?php echo $color_schemes[$design2]['600']?>"  id="nationalForecastUK">
		<h2>UK</h2>
		<div style="padding:10px">
			<?php
				foreach($dataUK['RegionalFcst']['FcstPeriods']['Period'] as $period){
					$paragraph = $period['Paragraph'];
					if(array_key_exists('title',$paragraph)){
						echo "<span style='font-weight:bold;font-size:1.1em;color:#".$color_schemes[$design2]['200']."'>".str_replace(':','',$paragraph['title'])."</span><br>";
						echo $paragraph['$'];
						echo "<br><br>";
					}
					else{
						foreach ($paragraph as $item){
							if($item['title']=="Headline:"){
								echo "<span style='font-weight:bold;font-variant:small-caps;font-size:1.4em'>".$item['$']."</span>";
							}
							else{
								echo "<span style='font-weight:bold;font-size:1.1em;color:#".$color_schemes[$design2]['200']."'>".str_replace(':','',$item['title'])."</span><br>";
								echo $item['$'];
							}
							
							echo "<br><br>";
						}
					}
				}
			?>
		</div>
		<div style="width:100%;text-align:center;font-size:0.8em">Contains public sector information licensed under the Open Government Licence</div><br>
		<div style="width:100%;text-align:center"><span class="more" onclick="$('#nationalForecastUK').slideToggle(600);"><?php echo lang('hide','l')?></span></div>
		<br>
	</div>
	<div style="width:98%;padding-top:10px;margin:0 auto;text-align:justify;background:#<?php echo $color_schemes[$design2]['600']?>" id="regionalForecastUK">
		<div style="width:100%;text-align:center">
			<select id="regionalUKBlockSelector" class="button2">
				<option value="os" <?php if($region=="os"){ echo "selected"; }?>>Orkney & Shetland</option>
				<option value="he" <?php if($region=="he"){ echo "selected"; }?>>Highland & Eilean Siar</option>
				<option value="gr" <?php if($region=="gr"){ echo "selected"; }?>>Grampian</option>
				<option value="ta" <?php if($region=="ta"){ echo "selected"; }?>>Tayside</option>
				<option value="st" <?php if($region=="st"){ echo "selected"; }?>>Strathclyde</option>
				<option value="dg" <?php if($region=="dg"){ echo "selected"; }?>>Dumfries, Galloway, Lothian</option>
				<option value="ni" <?php if($region=="ni"){ echo "selected"; }?>>Northern Ireland</option>
				<option value="yh" <?php if($region=="yh"){ echo "selected"; }?>>Yorkshire & the Humber</option>
				<option value="ne" <?php if($region=="ne"){ echo "selected"; }?>>Northeast England</option>
				<option value="em" <?php if($region=="em"){ echo "selected"; }?>>East Midlands</option>
				<option value="ee" <?php if($region=="ee"){ echo "selected"; }?>>East of England</option>
				<option value="se" <?php if($region=="se"){ echo "selected"; }?>>London & Southeast England</option>
				<option value="nw" <?php if($region=="nw"){ echo "selected"; }?>>Northwest England</option>
				<option value="wm" <?php if($region=="wm"){ echo "selected"; }?>>West Midlands</option>
				<option value="sw" <?php if($region=="sw"){ echo "selected"; }?>>Southwest England</option>
				<option value="wl" <?php if($region=="wl"){ echo "selected"; }?>>Wales</option>
			</select>
		</div>
		<div style="padding:10px" id="ukRegionalDiv">
			<?php
				foreach($dataRegional['RegionalFcst']['FcstPeriods']['Period'] as $period){
					$paragraph = $period['Paragraph'];
					if(array_key_exists('title',$paragraph)){
						echo "<span style='font-weight:bold;font-size:1.1em;color:#".$color_schemes[$design2]['200']."'>".str_replace(':','',$paragraph['title'])."</span><br>";
						echo $paragraph['$'];
						echo "<br><br>";
					}
					else{
						foreach ($paragraph as $item){
							if($item['title']=="Headline:"){
								echo "<span style='font-weight:bold;font-variant:small-caps;font-size:1.4em'>".$item['$']."</span>";
							}
							else{
								echo "<span style='font-weight:bold;font-size:1.1em;color:#".$color_schemes[$design2]['200']."'>".str_replace(':','',$item['title'])."</span><br>";
								echo $item['$'];
							}
							
							echo "<br><br>";
						}
					}
				}
			?>
		</div>
		<div style="width:100%;text-align:center;font-size:0.8em">Contains public sector information licensed under the Open Government Licence</div><br>
		<div style="width:100%;text-align:center"><span class="more" onclick="$('#regionalForecastUK').slideToggle(600);"><?php echo lang('hide','l')?></span></div>
		<br>
	</div>
	<br>
	<script>
		$("#nationalForecastUK").hide();
		$("#regionalForecastUK").hide();
		$("#showNationalUK").click(function(){
			$("#regionalForecastUK").hide();
			$("#nationalForecastUK").show();
		});
		$("#showRegionalUK").click(function(){
			$("#nationalForecastUK").hide();
			$("#regionalForecastUK").show();
		});
		$("#regionalUKBlockSelector").change(function(){
			newRegion = $("#regionalUKBlockSelector").val();
			$("#ukRegionalDiv").load("homepage/blocks/regionalUK/regionalLoader.php?region="+newRegion);
		})
	</script>