<?php

	# 		Sun/Moon rise/set
	# 		Namespace:		riset
	#		Meteotemplate Block
	
	# 		v1.1 - Jan 29, 2016
	#			- added responsiveness
	#			- bug fixes	
	# 		v2.0 - Mar 14, 2016
	#			- length of the day calculations
	#			- length of the day pie chart
	# 		v2.1 - Mar 30, 2016
	#			- bug fix for pie chart size
	# 		v3.0 - Aug 16, 2016
	#			- new pie chart with day length percentage
	# 		v4.0 - Sep 23, 2016
	#			- new day/night stage diagram
	# 		v4.1 - Jan 16, 2017
	#			- time formats unified with main template settings
	# 		v5.0 - Feb 11, 2017 
	# 			- added table with longest day, shortest day, equinox and today's offsets
	# 			- added diagram of station latitude
	# 			- changed "night" icon 
	# 			- CSS fixes for light version 
	# 			- fixed incorrect percentage calculation for Souther hemisphere
	# 		v6.0 - Feb 21, 2017 
	# 			- added day/night length percentages
	# 			- added day/night pie chart
	# 			- added twilight pie chart
	# 		v6.1 - Feb 22, 2017
	# 			- rotated twilight chart
	# 			- added labels to twilight chart
	# 			- added option to auto-open the block
	# 		v6.2 - Feb 23, 2017
	# 			- CSS tweaks
	# 		v6.3 - Mar 17, 2017
	# 			- optimization
	# 		v6.4 - Apr 2, 2017
	# 			- fixes a bug with color overlap in the day time diagram
	# 		v6.5 - Apr 3, 2017
	# 			- minor bug fixes
	# 		v6.6 - May 6, 2017
	# 			- bug fix where pie chart was not working when astronomical twilight was after midnight
	# 		v6.7 - May 9, 2017
	# 			- bug fix for twilight times at high latitudes
	# 		v6.8 - May 30, 2017
	# 			- minor bug fix
	# 		v6.9 - Jun 26, 2017
	# 			- improved styling
	# 			- bug fixes
	# 		v7.0 - Dec 7, 2017
	# 			- added option to hide the station latitude relative to equator position diagram
		
	
	// load theme
	$designTheme = json_decode(file_get_contents("../../css/theme.txt"),true);
	$theme = $designTheme['theme'];

	if(file_exists("settings.php")){
		include("settings.php");
	}
	else{
		echo "Please go to your admin section and go through the settings for this block first.";
		die();
	}
	
	include("../../../config.php");
	include("../../../scripts/functions.php");
	include($baseURL."css/design.php");
	
	$languageRaw = file_get_contents($baseURL."lang/gb.php");
	$language['gb'] = json_decode($languageRaw,true);
	$languageRaw = file_get_contents($baseURL."lang/".$lang.".php");
	$language[$lang] = json_decode($languageRaw,true);

	$stationTimezone = new DateTimeZone($stationTZ);
	$stationOffset  = $stationTimezone->getOffset(new DateTime)/3600;
	
	$sunRise = date_sunrise((time()+($stationOffset*60*60)),SUNFUNCS_RET_STRING,$stationLat,$stationLon,90.5,($stationOffset));
	$sunSet = date_sunset((time()+($stationOffset*60*60)),SUNFUNCS_RET_STRING,$stationLat,$stationLon,90.5,($stationOffset));
	$sunRiseTS = date_sunrise((time()+($stationOffset*60*60)),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5,($stationOffset));
	$sunSetTS = date_sunset((time()+($stationOffset*60*60)),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5,($stationOffset));
	
	
	
	// calculate percentage
	$sr = date_sunrise(time(),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
	$ss = date_sunset(time(),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
	
	if(time()>=$sr && time()<=$ss){
		$phaseDay = "sun";
		$phaseColor = "rgba(255,255,38,0.6)";
		$sunAnglePercent = ((time()-$sr)/($ss-$sr))*100;
	}
	if(time()>$ss){
		$tSR = date_sunrise(strtotime('tomorrow'),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
		$phaseDay = "moon";
		$phaseColor = "rgba(102,102,102,0.6)";
		$sunAnglePercent = ((time()-$ss)/($tSR-$ss))*100;
	}
	if(time()<$sr){
		$ySS = date_sunset(strtotime('yesterday'),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
		$phaseDay = "moon";
		$phaseColor = "rgba(102,102,102,0.6)";
		$sunAnglePercent = ((time()-$ySS)/($sr-$ySS))*100;
	}
	
	$diff = round(($sunSetTS - $sunRiseTS)/2);
	
	$todayMidnight = strtotime(date("Y-m-d",$sunRiseTS)." 00:00:01");
	$startAngle = (24*60*60)/($sunRiseTS - $todayMidnight)*360;
	
	$transitTime = $sunRiseTS + $diff;
	$transit = date($timeFormat, $transitTime);

	$diff = ($sunSetTS-$sunRiseTS)/60;
	$diffN = 1441 - $diff;
	$diffM = $diff % 60;
	if($diffM<10){
		$diffM = "0".$diffM;
	}
	$diffNM = $diffN % 60;
	if($diffNM<10){
		$diffNM = "0".$diffNM;
	}
	$dayLength = floor($diff/60).lang('hAbbr','l')." ".$diffM.lang('minAbbr','l');
	$nightLength = floor($diffN/60).lang('hAbbr','l')." ".$diffNM.lang('minAbbr','l');
	
	$output['sunRise'] = date($timeFormat,strtotime($sunRise));
	$output['sunSet'] = date($timeFormat,strtotime($sunSet));
	$output['sunTransit'] = $transit;
	$output['dayLength'] = $dayLength;
	$output['nightLength'] = $nightLength;
	
	$mp = new moonPhase(time());
	$img_phase = $mp->getPositionInCycle();
	$intervals = 118;
	$moonIcon = round(($img_phase/(1/$intervals)));
	$moonIllumination = $mp->getPercentOfIllumination();
	$moonNextFull = $mp->getDaysUntilNextFullMoon();
	$moonNextNew =  $mp->getDaysUntilNextNewMoon();
	
	$moontimes = new MoonRiSet($stationLat, $stationLon, $stationTZ);
	$moontimes->setDate(date("Y"), date("m"), date("d"));
	$moonRise = $moontimes->rise["timestamp"];
	$moonSet = $moontimes->set["timestamp"];
	if($moonSet>$moonRise){
		$moonDiff = $moonSet-$moonRise;
		$moonDiff = $moonDiff / 2;
		$moonTransit = $moonRise + $moonDiff;
	}
	else{
		$moonDiff = $moonRise-$moonSet;
		$moonDiff = $moonDiff / 2;
		$moonTransit = $moonSet + $moonDiff;
	}
	
	$output['moonRise'] = date($timeFormat,$moonRise);
	$output['moonSet'] = date($timeFormat,$moonSet);
	$output['moonTransit'] = date($timeFormat,$moonTransit);
	$output['moonIcon'] = $moonIcon;
	$output['moonIllumination'] = $moonIllumination;

	if($stationLat>0){
		$longestDayLength1 = date_sunset(strtotime(date("Y")."-6-21"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5)-date_sunrise(strtotime(date("Y")."-6-21"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
		$longestDayLength2 = date_sunset(strtotime(date("Y")."-6-22"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5)-date_sunrise(strtotime(date("Y")."-6-22"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
		$longestDayLength3 = date_sunset(strtotime(date("Y")."-6-23"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5)-date_sunrise(strtotime(date("Y")."-6-23"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
		$longestDayLength4 = date_sunset(strtotime(date("Y")."-6-20"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5)-date_sunrise(strtotime(date("Y")."-6-20"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);

		$shortestDayLength1 = date_sunset(strtotime(date("Y")."-12-21"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5)-date_sunrise(strtotime(date("Y")."-12-21"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
		$shortestDayLength2 = date_sunset(strtotime(date("Y")."-12-22"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5)-date_sunrise(strtotime(date("Y")."-12-22"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
		$shortestDayLength3 = date_sunset(strtotime(date("Y")."-12-23"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5)-date_sunrise(strtotime(date("Y")."-12-23"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
		$shortestDayLength4 = date_sunset(strtotime(date("Y")."-12-20"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5)-date_sunrise(strtotime(date("Y")."-12-20"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
	}
	else{
		$longestDayLength1 = date_sunset(strtotime(date("Y")."-12-21"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5)-date_sunrise(strtotime(date("Y")."-12-21"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
		$longestDayLength2 = date_sunset(strtotime(date("Y")."-12-22"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5)-date_sunrise(strtotime(date("Y")."-12-22"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
		$longestDayLength3 = date_sunset(strtotime(date("Y")."-12-23"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5)-date_sunrise(strtotime(date("Y")."-12-23"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
		$longestDayLength4 = date_sunset(strtotime(date("Y")."-12-20"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5)-date_sunrise(strtotime(date("Y")."-12-20"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);

		$shortestDayLength1 = date_sunset(strtotime(date("Y")."-6-21"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5)-date_sunrise(strtotime(date("Y")."-6-21"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
		$shortestDayLength2 = date_sunset(strtotime(date("Y")."-6-22"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5)-date_sunrise(strtotime(date("Y")."-6-22"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
		$shortestDayLength3 = date_sunset(strtotime(date("Y")."-6-23"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5)-date_sunrise(strtotime(date("Y")."-6-23"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
		$shortestDayLength4 = date_sunset(strtotime(date("Y")."-6-20"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5)-date_sunrise(strtotime(date("Y")."-6-20"),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
	}

	$longestDayLength = max($longestDayLength1,$longestDayLength2,$longestDayLength3,$longestDayLength4);
	$shortestDayLength = min($shortestDayLength1,$shortestDayLength2,$shortestDayLength3,$shortestDayLength4);

	$dayLengths['longestDay'] = $longestDayLength;
	$dayLengths['shortestDay'] = $shortestDayLength;
	$dayLengths['today'] = $sunSetTS - $sunRiseTS;

	$dayLengthToday = $sunSetTS - $sunRiseTS;
	$dayLengthYesterday = date_sunset(strtotime('yesterday')+($stationOffset*60*60),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5,$stationOffset) - date_sunrise(strtotime('yesterday')+($stationOffset*60*60),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);
	$dayLengthTomorrow = date_sunset(strtotime('tomorrow')+($stationOffset*60*60),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5,$stationOffset) - date_sunrise(strtotime('tomorrow')+($stationOffset*60*60),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5);

	$dayLengthToday = date_sunset(strtotime('today')+($stationOffset*60*60),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5,$stationOffset) - date_sunrise(strtotime('today')+($stationOffset*60*60),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5,$stationOffset);
	
	$dayPercentage = round($dayLengthToday/$longestDayLength*100,1);
	$dayPercentageTotal = round($dayLengthToday/$longestDayLength*100,1);
	
	$yesterdayDifference = $dayLengthYesterday - $dayLengthToday;
	$tomorrowDifference = $dayLengthTomorrow - $dayLengthToday;
	
	if($yesterdayDifference>0){
		$yesterdayDifferenceMin = "+".floor($yesterdayDifference/60);
		$yesterdayDifferenceSec = round($yesterdayDifference-60*$yesterdayDifferenceMin);
	}
	else{
		$yesterdayDifference = abs($yesterdayDifference);
		$yesterdayDifferenceMin = floor($yesterdayDifference/60);
		$yesterdayDifferenceSec = round($yesterdayDifference-60*$yesterdayDifferenceMin);
		$yesterdayDifferenceMin = $yesterdayDifferenceMin * -1;
	}
	
	if($tomorrowDifference>0){
		$tomorrowDifferenceMin = "+".floor($tomorrowDifference/60);
		$tomorrowDifferenceSec = round($tomorrowDifference-60*$tomorrowDifferenceMin);
	}
	else{
		$tomorrowDifference = abs($tomorrowDifference);
		$tomorrowDifferenceMin = floor($tomorrowDifference/60);
		$tomorrowDifferenceSec = round($tomorrowDifference-60*$tomorrowDifferenceMin);
		$tomorrowDifferenceMin = $tomorrowDifferenceMin * -1;
	}
	
	$x = $sunAnglePercent;
	if($x>50){
		$x = 100-$x;
	}

	if($x<10){
		$topHeight = 47.7;
	}
	if($x>=8 && $x<12){
		$topHeight = 20;
	}
	if($x>=12 && $x<17){
		$topHeight = 12;
	}
	if($x>=17 && $x<25){
		$topHeight = 5;
	}
	if($x>=25 && $x<30){
		$topHeight = 0;
	}
	if($x>=30 && $x<40){
		$topHeight = -7;
	}
	if($x>=40 && $x<=50){
		$topHeight = -12;
	}

	// twiglight pie 
	// Normal
	$pie['sunRise'] = date_sunrise((time()+($stationOffset*60*60)),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5,($stationOffset));
	$pie['sunSet'] = date_sunset((time()+($stationOffset*60*60)),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,90.5,($stationOffset));
	$pie['astroRise'] = date_sunrise((time()+($stationOffset*60*60)),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,108,($stationOffset));
	$pie['astroSet'] = date_sunset((time()+($stationOffset*60*60)),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,108,($stationOffset));
	$pie['nauticalRise'] = date_sunrise((time()+($stationOffset*60*60)),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,102,($stationOffset));
	$pie['nauticalSet'] = date_sunset((time()+($stationOffset*60*60)),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,102,($stationOffset));
	$pie['civilRise'] = date_sunrise((time()+($stationOffset*60*60)),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,96,($stationOffset));
	$pie['civilSet'] = date_sunset((time()+($stationOffset*60*60)),SUNFUNCS_RET_TIMESTAMP,$stationLat,$stationLon,96,($stationOffset));


	$today = date("Y",(time()+($stationOffset*60*60)))."-".date("m",(time()+($stationOffset*60*60)))."-".date("d",(time()+($stationOffset*60*60)));

	$midnight = strtotime($today." 00:00");
	$midnightTomorrow = $midnight + 24*60*60;

	if($pie['astroRise']!=""){
		if(date("Ymd",$pie['astroRise'])!=date("Ymd",$pie['astroSet'])){
			$pieSlices[] = $pie['astroSet'] - strtotime(date("Y-m-d",$pie['astroSet'])." 00:00");
		}
		else{
			$pieSlices[] = 0;
		}
		$pieSlices[] = $pie['astroRise'] - $midnight;
		$pieSlices[] = $pie['nauticalRise'] - $pie['astroRise'];
		$pieSlices[] = $pie['civilRise'] - $pie['nauticalRise'];
		$pieSlices[] = $pie['sunRise'] - $pie['civilRise'];
		$pieSlices[] = $pie['sunSet'] - $pie['sunRise'];
		$pieSlices[] = $pie['civilSet'] - $pie['sunSet'];
		$pieSlices[] = $pie['nauticalSet'] - $pie['civilSet'];
		$pieSlices[] = $pie['astroSet'] - $pie['nauticalSet'];
		if(date("Ymd",$pie['astroRise'])!=date("Ymd",$pie['astroSet'])){
			$pieSlices[] = 0;
		}
		else{
			$pieSlices[] = $midnightTomorrow - $pie['astroSet'];
		}
	}
	if($pie['astroRise']=="" && $pie['nauticalRise']!=""){
		if(date("Ymd",$pie['nauticalRise'])!=date("Ymd",$pie['astroSet'])){
			$pieSlices[] = $pie['astroSet'] - strtotime(date("Y-m-d",$pie['astroSet'])." 00:00");
		}
		else{
			$pieSlices[] = 0;
		}
		$pieSlices[] = $pie['nauticalRise'] - $midnight;
		$pieSlices[] = $pie['civilRise'] - $pie['nauticalRise'];
		$pieSlices[] = $pie['sunRise'] - $pie['civilRise'];
		$pieSlices[] = $pie['sunSet'] - $pie['sunRise'];
		$pieSlices[] = $pie['civilSet'] - $pie['sunSet'];
		$pieSlices[] = $pie['nauticalSet'] - $pie['civilSet'];
		if(date("Ymd",$pie['nauticalRise'])!=date("Ymd",$pie['nauticalSet'])){
			$pieSlices[] = 0;
		}
		else{
			$pieSlices[] = $midnightTomorrow - $pie['nauticalSet'];
		}
	}
	if($pie['astroRise']=="" && $pie['nauticalRise']==""){
		if(date("Ymd",$pie['civilRise'])!=date("Ymd",$pie['civilSet'])){
			$pieSlices[] = $pie['civilSet'] - strtotime(date("Y-m-d",$pie['civilSet'])." 00:00");
		}
		else{
			$pieSlices[] = 0;
		}
		$pieSlices[] = $pie['civilRise'] - $midnight;
		$pieSlices[] = $pie['sunRise'] - $pie['civilRise'];
		$pieSlices[] = $pie['sunSet'] - $pie['sunRise'];
		$pieSlices[] = $pie['civilSet'] - $pie['sunSet'];
		if(date("Ymd",$pie['civilRise'])!=date("Ymd",$pie['civilSet'])){
			$pieSlices[] = 0;
		}
		else{
			$pieSlices[] = $midnightTomorrow - $pie['civilSet'];
		}
	}
	if(!$autoOpenRiset){
		$textInitial = lang('more','c');
	}
	else{
		$textInitial = lang('hide','c');
	}

	function convertDuration($time){
		$hours = floor($time/3600);
		$mins = floor(($time-3600*$hours)/60);
		$seconds = $time - ($hours*3600) - ($mins*60);
		$seconds = round($seconds);
		if($seconds<10){
			$seconds = " ".$seconds;
		}
		if($hours>0 && $mins>0){
			return $hours." h ".$mins." min ".$seconds." s";
		}
		else if($hours==0 && $mins>0){
			return $mins." min ".$seconds." s";
		}
		else{
			return "0s";
		}
	}
?>
	<style>
		.sunIcon{
			width: 100%;
			max-width: 30px;
		}
		.pieContainer {
		  height: 100px;
		  position: relative;
		  margin: 0 auto;
		}
		.pieBackground {
		  position: absolute;
		  width: 100px;
		  height: 100px;
		  border-radius: 50px;
		  background: #444444;
		} 

		.pie {
		  transition: all 1s;
		  position: absolute;
		  width: 100px;
		  height: 100px;
		  border-radius: 50px;
		  clip: rect(0px, 50px, 100px, 0px);
		}

		.hold {
		  position: absolute;
		  width: 100px;
		  height: 100px;
		  border-radius: 50px;
		  clip: rect(0px, 100px, 100px, 50px);
		}

		#pieSlice1 .pie {
		  background-color: #0080ff;
		  <?php
			if($dayPercentageTotal>50){
				echo "transform:rotate(180deg);";
			}
			else{
				echo "transform:rotate(".($dayPercentageTotal*3.6)."deg);";
			}
		  ?>  
		}
		<?php
			if($dayPercentageTotal>50){
		?>
				#pieSlice2 {
				  transform: rotate(180deg);
				}

				#pieSlice2 .pie {
				  background-color: #0080ff;
				  <?php echo "transform:rotate(".(($dayPercentageTotal-50)*3.6)."deg);";?>
				}
		<?php 
			}
		?>
		.innerCircle {
		  position: absolute;
		  width: 80px;
		  height: 80px;
		  border-radius: 40px;
		  top: 10px;
		  left: 10px; 
		  background-color: #<?php echo $color_schemes[$design2]['900']?>;
		  color: white;
		}
		.innerCircle .contentPie {
		  position: absolute;
		  display: block;
		  width: 80px;
		  top: 25px;
		  left: 0;
		  text-align: center;
		  font-size: 25px;
		}
		
		.risetSunmoon {
			position: relative;
			width: 300px;
			height: 60px;
			margin: 0 auto;
			margin-bottom:20px;
		}
		.risetSun-times {
			margin: 0 auto;
			width: 200px;
			height: 60px;
			border-bottom: 2px solid #999;
			overflow: hidden;
			position: relative;
		}
		.risetSun-path {
			width: 98%;
			overflow: hidden!important;
			<?php
				if($theme=="dark"){
			?>
					border: 1px dashed #eeeeee;
			<?php 
				}
				else{
			?>		
					border: 1px dashed #000000;
			<?php
				}
			?>
			border-radius: 50%;
			position: relative;
		}
		.risetSymbolImg{
			width:25px;
			position:absolute;
			z-index:2;
			left: <?php echo 50 + 2*$sunAnglePercent-12.5 - 3?>px;
			top: <?php echo $topHeight?>px;
		}
		.risetSun-animation {
			width: <?php echo $sunAnglePercent?>%;
			height: 150px;
			background-color: <?php echo $phaseColor?>;
		}
	</style>
	<h2><?php echo date($dateFormat,time())?></h2>
	<br>
	<div class="risetSunmoon">
		<img src="homepage/blocks/riset/icons/<?php echo $theme?>/<?php echo $phaseDay?>.png" class="risetSymbolImg" alt="">
		<div class="risetSun-times">
			
			<div class="risetSun-path">
				<div class="risetSun-animation"></div>
			</div>
		</div>
	</div>
	<table style="width:100%">
		<tr>
			<td style="text-align:center;width:33%">
				<img src="homepage/blocks/riset/icons/<?php echo $theme?>/sunrise.png" class="sunIcon tooltip" alt=""> 
			</td>
			<td style="text-align:center;width:33%">
				<img src="homepage/blocks/riset/icons/<?php echo $theme?>/suntransit.png" class="sunIcon" alt="">
			</td>
			<td style="text-align:center;width:33%">
				<img src="homepage/blocks/riset/icons/<?php echo $theme?>/sunset.png" class="sunIcon tooltip" alt="">
			</td>
		</tr>
		<tr>
			<td style="text-align:center">
				<?php echo $output['sunRise']?>
			</td>
			<td>
				<?php echo $output['sunTransit']?>
			</td>
			<td>
				<?php echo $output['sunSet']?>
			</td>							
		</tr>
		<tr>
			<td style="text-align:center;width:33%">
				<img src="homepage/blocks/riset/icons/<?php echo $theme?>/moonrise.png" class="sunIcon tooltip" alt=""> 
			</td>
			<td style="text-align:center;width:33%">
				<img src="homepage/blocks/riset/icons/<?php echo $theme?>/moontransit.png" class="sunIcon" alt="">
			</td>
			<td style="text-align:center;width:33%">
				<img src="homepage/blocks/riset/icons/<?php echo $theme?>/moonset.png" class="sunIcon tooltip" alt="">
			</td>
		</tr>
		<tr>
			<td style="text-align:center">
				<?php echo $output['moonRise']?>
			</td>
			<td>
				<?php echo $output['moonTransit']?>
			</td>
			<td>
				<?php echo $output['moonSet']?>
			</td>							
		</tr>
	</table>
	<table style="width:100%;table-layout:fixed">
		<tr>
			<td style="text-align:center">
				<img src="homepage/blocks/riset/icons/<?php echo $theme?>/sun.png" class="sunIcon tooltip" alt="">
			</td>
			<td rowspan="2" style="width:100px">
				<canvas id="risetDayProportion" width="60" height="60" style="padding-top:10px"/>
			</td>
			<td style="text-align:center">
				<img src="homepage/blocks/riset/icons/<?php echo $theme?>/night.png" class="sunIcon tooltip" alt="">
			</td>
		</tr>
		<tr>
			<td>
				<?php echo $output['dayLength']?><br><span style="font-size:0.8em"><?php echo number_format(($dayLengthToday/(24*60*60))*100,1,".","")?>%
			</td>
			<td>
				<?php echo $output['nightLength']?><br><span style="font-size:0.8em"><?php echo number_format(100-(($dayLengthToday/(24*60*60))*100),1,".","")?>%
			</td>
		</tr>
	</table>
</div>
	<div class="details" id="risetDetails">
		<br>
			<span style="font-size:1.3em;font-weight:bold;font-variant:small-caps">
				<?php echo lang('day length','c')?>
			</span>
		<table style="width:80%;margin:0 auto">
			<tr>
				<td style="text-align:left">
					<?php echo lang('yesterday','c')?>
				</td>
				<td style="text-align:right">
					<?php
						echo $yesterdayDifferenceMin. " min ".$yesterdayDifferenceSec." s";
					?>
				</td>
			</tr>
				<tr>
				<td style="text-align:left">
					<?php echo lang('tomorrow','c')?>
				</td>
				<td style="text-align:right">
					<?php
						echo $tomorrowDifferenceMin. " min ".$tomorrowDifferenceSec." s";
					?>
				</td>
			</tr>	
		</table>
		<table style="margin:0 auto;text-align:center;width:100px">
			<tr>
				<td>
					<div class="pieContainer">
						<div class="pieBackground"></div>
						<div id="pieSlice1" class="hold">
							<div class="pie"></div>
						</div>
						<?php
							if($dayPercentageTotal>50){
						?>
						<div id="pieSlice2" class="hold">
							<div class="pie"></div>
						</div>
						<?php
							}
						?>
						<div class="innerCircle">
							<div class="contentPie">
								<?php echo $dayPercentageTotal?>%
							</div>
						</div>
					</div>
				</td>
			</tr>
		</table>
		% <?php echo lang('longest day','l')?>
		<?php 
			$color1 = $theme=="dark" ? "white" : "black";
		?>
		<br><br>
		<table class="table" style="width:95%;margin:0 auto">
			<tr>
				<th style="padding-left:2px;color:<?php echo $color1?>">
					<?php echo lang('longest day','c')?>
				</th>
				<td style="text-align:right">
					<?php echo convertDuration($dayLengths['longestDay']);?>
					<br>
					<span style="font-size:0.8em">
						<?php echo lang("today","c")?>: - <?php echo convertDuration($dayLengths['longestDay']-$dayLengths['today']);?>
					</span>
				</td>
			</tr>
			<tr>
				<th style="padding-left:2px;color:<?php echo $color1?>">
					<?php echo lang('shortest day','c')?>
				</th>
				<td style="text-align:right">
					<?php echo convertDuration($dayLengths['shortestDay']);?>
					<br>
					<span style="font-size:0.8em">
						<?php echo lang("today","c")?>: + <?php echo convertDuration($dayLengths['today']-$dayLengths['shortestDay']);?>
					</span>
				</td>
			</tr>
			<tr>
				<th style="padding-left:2px;color:<?php echo $color1?>">
					<?php echo lang('equinox','c')?>
				</th>
				<td style="text-align:right">
					12 h
					<br>
					<span style="font-size:0.8em">
						<?php echo lang("today","c")?>: 	
						<?php 
							if($dayLengths['today']>12*60*60){
								echo "+ ".convertDuration($dayLengths['today']-(12*60*60));
							}
							else{
								echo "- ".convertDuration((12*60*60) - $dayLengths['today']);
							}
						?>
					</span>
				</td>
			</tr>
		</table>
		<?php 
			if($showStatPosition){
		?>
			<?php
				$color2 = $theme=="dark" ? $color_schemes[$design2]['300'] : $color_schemes[$design2]['700'];
				if($stationLat>0){
					$offsetLat = 90 - $stationLat;
			?>
					<table style="width:95%;margin: 0 auto">
						<tr>
							<td style="width:50%;text-align:left;padding-left:5px">
								<?php echo lang('weather station','c')?>
								<br>
								<strong><?php echo number_format($stationLat,2,".","")." ".lang("coordN","u")?></strong>
							</td>
							<td>
								<span style="font-variant:small-caps"><?php echo lang('pole','l');?></span>
								<table style="width:50px;margin:0 auto">
									<tr>
										<td style="border-top:2px solid <?php echo $color1?>;border-bottom:2px solid <?php echo $color1?>;height:90px;position:relative">
											<div style="position:absolute;width:10px;height:10px;background:#<?php echo $color2?>;border-radius:50%;top:<?php echo $offsetLat?>px;left:17px"></div>
										</td>
									</tr>
								</table>
								<span style="font-variant:small-caps"><?php echo lang('equator','l');?></span>
							</td>
						</tr>
					</table>
					
			<?php 
				}
				else{
					$offsetLat = abs($stationLat);
			?>
					<table style="width:95%;margin: 0 auto">
						<tr>
							<td style="width:50%;text-align:left;padding-left:5px">
								<?php echo lang('weather station','c')?>
								<br>
								<strong><?php echo number_format(abs($stationLat),2,".","")." ".lang("coordS","u")?></strong>
							</td>
							<td>
								<span style="font-variant:small-caps"><?php echo lang('equator','l');?></span>
								<table style="width:50px;margin:0 auto">
									<tr>
										<td style="border-top:2px solid <?php echo $color1?>;border-bottom:2px solid <?php echo $color1?>;height:90px;position:relative">
											<div style="position:absolute;width:10px;height:10px;background:#<?php echo $color2?>;border-radius:50%;top:<?php echo $offsetLat?>px;left:17px"></div>
										</td>
									</tr>
								</table>
								<span style="font-variant:small-caps"><?php echo lang('pole','l');?></span>
							</td>
						</tr>
					</table>
			<?php 
				}
			}
		?>
		<table style="width:98%;margin:0 auto">
			<tr>
				<td style="font-size:0.9em;font-variant:small-caps">
					<?php echo lang('midnight','c')?><br>
					<canvas id="risetTwilightPie" width="150" height="150"/ style="transform: rotate(-90deg);"></canvas><br>
					<?php echo lang('noon','c')?>
				</td>
				<td>
					<table style="width:98%;margin:0 auto;font-size:0.8em">
						<tr>
							<td style="width:20px;background:#333">
							</td>
							<td style="text-align:left;padding-left:5px">
								<?php echo lang('night','c')?>
							</td>
						</tr>
						<tr>
							<td style="font-weight:bold;font-variant:small-caps;text-align:left;padding-top:5px" colspan="2">
								<?php echo lang('twilight','c');?>
							</td>
						</tr>
						<tr>
							<td style="width:20px;background:#777">
							</td>
							<td style="text-align:left;padding-left:5px">
								<?php echo lang('astronomical','c')?>
							</td>
						</tr>
						<tr>
							<td style="width:20px;background:#ada375">
							</td>
							<td style="text-align:left;padding-left:5px">
								<?php echo lang('nautical','c')?>
							</td>
						</tr>
						<tr>
							<td style="width:20px;background:#d6bf55">
							</td>
							<td style="text-align:left;padding-left:5px">
								<?php echo lang('civil','c')?>
							</td>
						</tr>
						<tr>
							<td style="width:20px;background:#f4df42">
							</td>
							<td style="text-align:left;padding-left:5px">
								<?php echo lang('day','c')?>
							</td>
						</tr>
					</table>
				</td>
			</tr>
		</table>
	</div>
	<br>
	<span id="risetMoreSpan" class="more" onclick="txt = $('#risetDetails').is(':visible') ? '<?php echo lang('more','l')?>' : '<?php echo lang('hide','l')?>';$('#risetDetails').slideToggle(800);$(window).resize();$(this).text(txt)">
			<?php echo $textInitial?>
	</span>
	<script>
		var canvas = document.getElementById("risetDayProportion");
		var ctx = canvas.getContext("2d");
		var lastend = 0;
		var data = [<?php echo $dayLengthToday.",".(60*60*24-$dayLengthToday)?>];
		var myTotal = 0;
		var myColor = ['#f4df42','#565656'];

		for(var e = 0; e < data.length; e++){
			myTotal += data[e];
		}

		for (var i = 0; i < data.length; i++) {
		ctx.fillStyle = myColor[i];
		ctx.beginPath();
		ctx.moveTo(canvas.width/2,canvas.height/2);
		ctx.arc(canvas.width/2,canvas.height/2,canvas.height/2,lastend,lastend+(Math.PI*2*(data[i]/myTotal)),false);
		ctx.lineTo(canvas.width/2,canvas.height/2);
		ctx.fill();
		lastend += Math.PI*2*(data[i]/myTotal);
		}

		var canvas = document.getElementById("risetTwilightPie");
		var ctx = canvas.getContext("2d");
		var lastend = 0;
		var data = [<?php echo implode(",",$pieSlices)?>];
		var myTotal = 0;
		<?php 
			if($pie['astroRise']!=""){
		?>
				var myColor = ['#777','#333','#777','#ada375','#d6bf55','#f4df42','#d6bf55','#ada375','#777','#333'];
		<?php 
			}
		?>

		<?php 
			if($pie['astroRise']=="" && $pie['nauticalRise']!=""){
		?>
				var myColor = ['#333','#777','#ada375','#d6bf55','#f4df42','#d6bf55','#ada375','#777'];
		<?php 
			}
		?>

		<?php 
			if($pie['astroRise']=="" && $pie['nauticalRise']==""){
		?>
				var myColor = ['#777','#ada375','#d6bf55','#f4df42','#d6bf55','#ada375'];
		<?php 
			}
		?>

		for(var e = 0; e < data.length; e++)
		{
		myTotal += data[e];
		}

		for (var i = 0; i < data.length; i++) {
			ctx.fillStyle = myColor[i];
			ctx.beginPath();
			ctx.moveTo(canvas.width/2,canvas.height/2);
			ctx.arc(canvas.width/2,canvas.height/2,canvas.height/2,lastend,lastend+(Math.PI*2*(data[i]/myTotal)),false);
			ctx.lineTo(canvas.width/2,canvas.height/2);
			ctx.fill();
			lastend += Math.PI*2*(data[i]/myTotal);
		}
		<?php
			if($autoOpenRiset){
		?>

				$('#risetDetails').slideToggle(800);
		<?php
			}
		?>
	</script>